import numpy as np
from numba import jit

@jit(nopython=True)
def updated_signal(x, hexagonal=False):
	n = x[0].size
	M = np.zeros((n + 2, n + 2))  # dummy matrix to include boundary conditions

	# matrix body
	M[1:n + 1, 1:n + 1] = x
	# perimeter rows and columns
	M[1:n + 1, 0] = M[1:n + 1, n]  # first column equals second to last column
	M[1:n + 1, n + 1] = M[1:n + 1, 1]  # last column equals second column
	M[0, 1:n + 1] = M[n, 1:n + 1]  # first row equals second to last row
	M[n + 1, 1:n + 1] = M[1, 1:n + 1]  # last row equals second row

	# corners for hexagonal lattice
	# for square lattice, corners don't matter and can remain zero
	M[0, 0] = M[n, n]
	M[0, n + 1] = M[n, 1]
	M[n + 1, n + 1] = M[1, 1]
	M[n + 1, 0] = M[1, n]

	I = np.zeros((n, n))
	for i in range(1, n + 1):
		for j in range(1, n + 1):
			I[i - 1][j - 1] = (M[i + 1][j] + M[i - 1][j] + M[i][j + 1] + M[i][j - 1])
			if (i - 1) % 2 == 0:
				I[i - 1][j - 1] = I[i - 1][j - 1] + M[i + 1][j + 1] + M[i - 1][j + 1]
			else:
				I[i - 1][j - 1] = I[i - 1][j - 1] + M[i + 1][j - 1] + M[i - 1][j - 1]
	return (1./6)*I